/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.comm.TEInterface;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.activityfolder.ActivityFolder;
import com.quantumdata.sct.gui.activityfolder.EDIDResultFolder;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTComboBox;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.common.SCTRadioButton;
import com.quantumdata.sct.gui.common.SCTTextField;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;

public class EDIDDeclareFolder
extends ActivityFolder
implements ActionListener {
    private SCTRadioButton[] m_checkBoxes;
    private SCTPanel innerPanel;
    private SCTPanel innerPanel2;
    private SCTButton[] button;
    private EDIDResultFolder resultFolder;
    private EDIDResultFolder dataFolder;
    String tempStr = "";
    String fileStr = "Unknown";

    public EDIDDeclareFolder(ComplianceTesterToolUI complianceTesterToolUI, EDIDResultFolder eDIDResultFolder, EDIDResultFolder eDIDResultFolder2) {
        super(complianceTesterToolUI, "Declare");
        this.init();
        this.resultFolder = eDIDResultFolder;
        this.dataFolder = eDIDResultFolder2;
    }

    private void init() {
        this.setBackground(Color.white);
        this.m_checkBoxes = new SCTRadioButton[26];
        this.button = new SCTButton[3];
        this.m_checkBoxes[0] = new SCTRadioButton("CEC Root Device");
        this.m_checkBoxes[0].putClientProperty("Command", "CECR");
        this.m_checkBoxes[1] = new SCTRadioButton("HDTV");
        this.m_checkBoxes[1].putClientProperty("Command", "HDTV");
        this.m_checkBoxes[2] = new SCTRadioButton("YUV On Other");
        this.m_checkBoxes[2].putClientProperty("Command", "YUVO");
        this.m_checkBoxes[3] = new SCTRadioButton("60Hz");
        this.m_checkBoxes[3].putClientProperty("Command", "HZ60");
        this.m_checkBoxes[4] = new SCTRadioButton("50Hz");
        this.m_checkBoxes[4].putClientProperty("Command", "HZ50");
        this.m_checkBoxes[5] = new SCTRadioButton("640x480p/60Hz 4:3");
        this.m_checkBoxes[5].putClientProperty("Command", "FMT7");
        this.m_checkBoxes[5].setSelected(true);
        this.m_checkBoxes[6] = new SCTRadioButton("720x576p/50Hz 4:3");
        this.m_checkBoxes[6].putClientProperty("Command", "FMT6");
        this.m_checkBoxes[7] = new SCTRadioButton("720x480p/60Hz 4:3");
        this.m_checkBoxes[7].putClientProperty("Command", "FMT3");
        this.m_checkBoxes[8] = new SCTRadioButton("720x576p/50Hz 16:9");
        this.m_checkBoxes[8].putClientProperty("Command", "FMT9");
        this.m_checkBoxes[9] = new SCTRadioButton("720x480p/60Hz 16:9");
        this.m_checkBoxes[9].putClientProperty("Command", "FMT8");
        this.m_checkBoxes[10] = new SCTRadioButton("1280x720p/50Hz 16:9");
        this.m_checkBoxes[10].putClientProperty("Command", "FMT4");
        this.m_checkBoxes[11] = new SCTRadioButton("1280x720p/60Hz 16:9");
        this.m_checkBoxes[11].putClientProperty("Command", "FMT1");
        this.m_checkBoxes[12] = new SCTRadioButton("1920x1080i/50Hz 16:9");
        this.m_checkBoxes[12].putClientProperty("Command", "FMT5");
        this.m_checkBoxes[13] = new SCTRadioButton("1920x1080i/60Hz 16:9");
        this.m_checkBoxes[13].putClientProperty("Command", "FMT2");
        this.m_checkBoxes[14] = new SCTRadioButton("1440x576i/50Hz 4:3");
        this.m_checkBoxes[14].putClientProperty("Command", "FM12");
        this.m_checkBoxes[15] = new SCTRadioButton("1440x480i/60Hz 4:3");
        this.m_checkBoxes[15].putClientProperty("Command", "FM10");
        this.m_checkBoxes[16] = new SCTRadioButton("1440x576i/50Hz 16:9");
        this.m_checkBoxes[16].putClientProperty("Command", "FM13");
        this.m_checkBoxes[17] = new SCTRadioButton("1440x480i/60Hz 16:9");
        this.m_checkBoxes[17].putClientProperty("Command", "FM11");
        this.m_checkBoxes[18] = new SCTRadioButton("Connector Type A");
        this.m_checkBoxes[18].putClientProperty("Command", "CONA");
        this.m_checkBoxes[19] = new SCTRadioButton("720p/60Hz On Other");
        this.m_checkBoxes[19].putClientProperty("Command", "FMO1");
        this.m_checkBoxes[20] = new SCTRadioButton("720p/50Hz On Other");
        this.m_checkBoxes[20].putClientProperty("Command", "FMO4");
        this.m_checkBoxes[21] = new SCTRadioButton("1080i/60Hz On Other");
        this.m_checkBoxes[21].putClientProperty("Command", "FMO2");
        this.m_checkBoxes[22] = new SCTRadioButton("1080i/50Hz On Other");
        this.m_checkBoxes[22].putClientProperty("Command", "FMO5");
        this.m_checkBoxes[23] = new SCTRadioButton("Supports AI");
        this.m_checkBoxes[23].putClientProperty("Command", "AIOK");
        this.m_checkBoxes[24] = new SCTRadioButton("Basic Audio");
        this.m_checkBoxes[24].putClientProperty("Command", "BAUD");
        this.m_checkBoxes[25] = new SCTRadioButton("HDMI v1.3 (CEA-861D Rules)");
        this.m_checkBoxes[25].putClientProperty("Command", "WPRT");
        this.innerPanel = new SCTPanel();
        SCTComboBox sCTComboBox = new SCTComboBox();
        sCTComboBox.putClientProperty("Command", "OCNT");
        sCTComboBox.addItem(new String("HDMI Output Count: 0"));
        sCTComboBox.addItem(new String("HDMI Output Count: 1"));
        sCTComboBox.addItem(new String("HDMI Output Count: 2"));
        sCTComboBox.addItem(new String("HDMI Output Count: 3"));
        sCTComboBox.addItem(new String("HDMI Output Count: 4"));
        sCTComboBox.addItem(new String("HDMI Output Count: 5"));
        sCTComboBox.addItem(new String("HDMI Output Count: 6"));
        sCTComboBox.addItem(new String("HDMI Output Count: 7"));
        sCTComboBox.addItem(new String("HDMI Output Count: 8"));
        sCTComboBox.addItem(new String("HDMI Output Count: 9"));
        sCTComboBox.setFont(SCTConstants.SS_B_12);
        sCTComboBox.setBackground(Color.white);
        this.innerPanel.add(sCTComboBox);
        sCTComboBox = new SCTComboBox();
        sCTComboBox.putClientProperty("Command", "CIPN");
        sCTComboBox.addItem(new String("HDMI Input Port #: 0 (Not allowed!)"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 1"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 2"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 3"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 4"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 5"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 6"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 7"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 8"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 9"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 10"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 11"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 12"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 13"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 14"));
        sCTComboBox.addItem(new String("HDMI Input Port #: 15"));
        sCTComboBox.setSelectedIndex(1);
        sCTComboBox.setBackground(Color.white);
        sCTComboBox.setFont(SCTConstants.SS_B_12);
        this.innerPanel.add(sCTComboBox);
        this.innerPanel.add(this.m_checkBoxes[0]);
        sCTComboBox = new SCTComboBox();
        sCTComboBox.putClientProperty("Command", "PRAR");
        sCTComboBox.addItem(new String("Primary Aspect Ratio: 4:3"));
        sCTComboBox.addItem(new String("Primary Aspect Ratio: 16:9"));
        sCTComboBox.setFont(SCTConstants.SS_B_12);
        sCTComboBox.setBackground(Color.white);
        this.innerPanel.add(sCTComboBox);
        for (int i = 1; i < 26; ++i) {
            this.innerPanel.add(this.m_checkBoxes[i]);
        }
        this.innerPanel2 = new SCTPanel();
        this.button[0] = new SCTButton("Send CDF to 882");
        this.button[0].addActionListener(this);
        this.innerPanel2.add(this.button[0]);
        this.button[1] = new SCTButton("Create Reports");
        this.button[1].addActionListener(this);
        this.innerPanel2.add(this.button[1]);
        this.button[2] = new SCTButton("Save Reports to Card");
        this.button[2].addActionListener(this);
        this.innerPanel2.add(this.button[2]);
        SCTTextField sCTTextField = new SCTTextField("Input report name here.");
        this.innerPanel2.add(sCTTextField);
        this.innerPanel.setLayout(new GridLayout(15, 2, 0, 0));
        this.innerPanel2.setLayout(new GridLayout(1, 4, 0, 0));
        this.innerPanel2.setSize(new Dimension(700, 50));
        this.innerPanel2.setPreferredSize(new Dimension(700, 50));
        this.innerPanel2.setMaximumSize(new Dimension(700, 50));
        JScrollPane jScrollPane = new JScrollPane(this.innerPanel, 22, 30);
        jScrollPane.setLayout(new ScrollPaneLayout());
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)jScrollPane, "North");
        this.add((Component)this.innerPanel2, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (SCTSelection.instance().getCurrentConnection() == null) {
            MessageOptionPane.ShowErrorMessage(this, "No connection to the generator defined.  Please go to the Host menu.", "ERROR!");
            return;
        }
        TEInterface tEInterface = TEInterface.instance();
        if (!tEInterface.m_instrument.isConnected()) {
            return;
        }
        if (actionEvent.getSource() == this.button[0]) {
            for (int i = 0; i < this.innerPanel.getComponentCount(); ++i) {
                if (this.innerPanel.getComponent(i) instanceof SCTRadioButton) {
                    this.tempStr = ((SCTRadioButton)this.innerPanel.getComponent(i)).getClientProperty("Command") + " ";
                    this.tempStr = ((SCTRadioButton)this.innerPanel.getComponent(i)).isSelected() ? this.tempStr + "1" : this.tempStr + "0";
                } else if (this.innerPanel.getComponent(i) instanceof SCTComboBox) {
                    this.tempStr = ((SCTComboBox)this.innerPanel.getComponent(i)).getClientProperty("Command") + " " + ((SCTComboBox)this.innerPanel.getComponent(i)).getSelectedIndex();
                }
                if (this.tempStr.length() != 0) {
                    try {
                        tEInterface.setQuery("ECTX:" + this.tempStr);
                        tEInterface.sendCommand(true);
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
                    }
                }
                this.tempStr = "";
            }
            try {
                this.errorCheck(tEInterface);
            }
            catch (Exception exception) {
                MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
        if (actionEvent.getSource() == this.button[1]) {
            try {
                tEInterface.setQuery("ECTX:ECTU");
                tEInterface.sendCommand(true);
                this.errorCheck(tEInterface);
                this.resultFolder.switchURL("file:" + System.getProperty("user.dir") + System.getProperty("file.separator") + "/data/edid.htm");
                this.resultFolder.switchURL("http://" + SCTSelection.instance().getCurrentConnection().getName() + "/fs/reports/Edid_Compliance.htm");
                this.dataFolder.switchURL("file:" + System.getProperty("user.dir") + System.getProperty("file.separator") + "/data/edid.htm");
                this.dataFolder.switchURL("http://" + SCTSelection.instance().getCurrentConnection().getName() + "/fs/reports/Edid_Data.htm");
            }
            catch (Exception exception) {
                MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
        if (actionEvent.getSource() == this.button[2]) {
            for (int i = 0; i < this.innerPanel2.getComponentCount(); ++i) {
                if (!(this.innerPanel2.getComponent(i) instanceof SCTTextField)) continue;
                this.fileStr = ((SCTTextField)this.innerPanel2.getComponent(i)).getText();
            }
            try {
                tEInterface.setQuery("cp /Library/Reports/Edid_Compliance.htm /card0/" + this.fileStr + "Compliance.htm");
                tEInterface.sendCommand(true);
                tEInterface.setQuery("cp /Library/Reports/Edid_Data.htm /card0/" + this.fileStr + "Data.htm");
                tEInterface.sendCommand(true);
                this.errorCheck(tEInterface);
            }
            catch (Exception exception) {
                MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
    }

    public void errorCheck(TEInterface tEInterface) {
        String string = "";
        try {
            string = tEInterface.executeQueryWaitForResponse("ERRY?", 5);
        }
        catch (Exception exception) {
            MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
        }
        if (Integer.parseInt(string) > 0) {
            this.printGeneratorError(Integer.parseInt(string));
            try {
                tEInterface.setQuery("ERRC");
                tEInterface.sendCommand(true);
            }
            catch (Exception exception) {
                MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
    }

    public void printGeneratorError(int n) {
        String string = "Unknown error " + n + " occurred.  May not affect testing.";
        if (n == 1) {
            string = "Error!  Message sent to test equipment was not recognized!  (Error 1)";
        }
        if (n == 4) {
            string = "Error!  Message sent to test equipment had an invalid number of arguments! (Error 4)";
        }
        if (n == 6) {
            string = "Error!  File could not be used.  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 6)";
        }
        if (n == 99) {
            string = "Internal error!  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 99)";
        }
        if (n == 10031) {
            string = "Error!  Feature not enabled.  Please contact Quantum Data for licensing details. (Error 10031)";
        }
        if (n == 10300) {
            string = "CEC receive error - Message was not fully received. (Error 10300)";
        }
        if (n == 10301) {
            string = "CEC receive error - Timeout on the CEC line. (Error 10301)";
        }
        if (n == 10302) {
            string = "CEC receive error - Receive buffer error. (Error 10302)";
        }
        if (n == 10303) {
            string = "CEC receive error - Start bit timing incorrect. (Error 10303)";
        }
        if (n == 10304) {
            string = "CEC receive error - Receive buffer error - message dropped. (Error 10304)";
        }
        if (n == 10305) {
            string = "CEC receive error - Signal free time not adhered to. (Error 10305)";
        }
        if (n == 10310) {
            string = "CEC transmit error - CEC line error, send failed. (Error 10310)";
        }
        if (n == 10311) {
            string = "CEC transmit error - Arbitration was lost during send, send failed. (Error 10311)";
        }
        if (n == 10312) {
            string = "CEC transmit error - Message was not acknowledged.  Please retest. (Error 10312)";
        }
        if (n == 20000) {
            string = "Error!  Test equipment not connected to TME.  Please restart and connect.";
        }
        if (n == 20001) {
            string = "Error!  No value was entered by the tester when one was required!";
        }
        if (n == 20002) {
            string = "Error!  No selection was made by the tester when one was required!";
        }
        if (n == 20003) {
            string = "Error!  TME could not perform task (Exception occurred).";
        }
        if (n == 20005) {
            string = "Error!  Text input was not a number, when a number was expected.";
        }
        MessageOptionPane.ShowErrorMessage(this, string, "ERROR!");
    }
}

